/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp.srvutil;

import com.ibm.hsc.auiml.databeans.sfp.srvutil.ServiceUtilConstants;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnSortDescriptor;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class OperatorPanelServiceFunctionsBean
extends PanelBean
implements ServiceUtilConstants {
    private static final String TRACE_MASKD = "JOPSBN D";
    private static final String TRACE_MASKF = "JOPSBN F";
    private static final String TRACE_MASKT = "JOPSBN T";
    private boolean systemFunctionsMenuAvailable = true;
    private String bundle;
    private String descriptionTextKey;
    private String selectedSystem;
    private List partitionTable;
    private int[] partitionTableSelectedRows;
    private ColumnSortDescriptor[] partitionTableColumnsSort;

    public void setSystemFunctionsMenuAvailable(boolean bl) {
        this.systemFunctionsMenuAvailable = bl;
    }

    public void setPartitionFunctionsMenuEnabled(boolean bl) {
        this.userTaskManager.setEnabled("MenuPartitionFunctions", bl);
    }

    public void setDescriptionText(String string, String string2) {
        this.bundle = string;
        this.descriptionTextKey = string2;
    }

    public String getDescriptionText() {
        return HSCResourceBundleUtil.getMessage(this.bundle, this.descriptionTextKey);
    }

    public void setSelectedSystem(String string) {
        Trace.trace((String)TRACE_MASKF, (Object)("OPSFBean.setSelectedSystem(" + string + ")"));
        this.selectedSystem = string;
    }

    public String getSelectedSystem() {
        return this.selectedSystem;
    }

    public void setPartitionTable(List list) {
        Trace.trace((String)TRACE_MASKF, (Object)"<--> OPSFBean.setPartitionTable(List)");
        this.partitionTable = list;
    }

    public void setPartitionTableSelection(int[] nArray) {
        this.partitionTableSelectedRows = nArray;
        this.setPartitionFunctionsMenuEnabled(nArray.length > 0);
    }

    public int[] getPartitionTableSelection() {
        return this.partitionTableSelectedRows;
    }

    public void setPartitionTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) {
    }

    public ItemDescriptor[] getPartitionTableRowAt(int n) {
        String[] stringArray = (String[])this.partitionTable.get(n);
        return new ItemDescriptor[]{new ItemDescriptor(null, stringArray[0]), new ItemDescriptor(null, stringArray[1]), new ItemDescriptor(null, HSCResourceBundleUtil.getMessage(this.bundle, stringArray[2]))};
    }

    public int getPartitionTableRowCount() {
        return this.partitionTable.size();
    }

    public int getPartitionTableRowStatus() {
        return 3;
    }

    public void setPartitionTableSortCriteria(ColumnSortDescriptor[] columnSortDescriptorArray) {
        this.partitionTableColumnsSort = columnSortDescriptorArray;
    }

    public ColumnSortDescriptor[] getPartitionTableSortCriteria() {
        return this.partitionTableColumnsSort;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public void load() {
        Trace.trace((String)TRACE_MASKF, (Object)"<--> OPSFBean.load()");
        if (this.descriptionTextKey == null) {
            this.descriptionTextKey = "";
        }
        if (this.selectedSystem == null) {
            this.selectedSystem = "";
        }
        if (this.partitionTable == null) {
            this.partitionTable = new ArrayList();
        }
        this.partitionTableSelectedRows = new int[0];
    }

    public void prepare() {
        Trace.trace((String)TRACE_MASKF, (Object)"<--> OPSFBean.prepare()");
        this.userTaskManager.setShown("MenuSystemFunctions", this.systemFunctionsMenuAvailable);
        this.setPartitionFunctionsMenuEnabled(false);
        this.partitionTableColumnsSort = new ColumnSortDescriptor[0];
    }

    public void update(Object object) {
        Trace.trace((String)TRACE_MASKF, (Object)("<--> OPSFBean.update(" + object + ")"));
        String string = (String)object;
        ListIterator listIterator = this.partitionTable.listIterator();
        boolean bl = false;
        while (listIterator.hasNext() && !(bl = ((String[])listIterator.next())[1].equals(string))) {
        }
        if (bl) {
            listIterator.remove();
            if (this.partitionTable.size() == 0) {
                this.setPartitionFunctionsMenuEnabled(false);
            }
            this.partitionTableSelectedRows = new int[0];
            this.userTaskManager.refreshAllElements();
        }
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        Trace.trace((String)TRACE_MASKT, (Object)("--> OPSFBean.panelAction(" + taskActionEvent + ")"));
        this.userTaskManager.storeElement("PartitionTable");
        PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
        panelTaskletRequest.setSource((Object)this.getBeanName());
        Object var3_3 = null;
        if (taskActionEvent.getActionCommand().equals("CANCEL")) {
            panelTaskletRequest.setCanceled();
        } else {
            try {
                FunctionDataBean functionDataBean = new FunctionDataBean(taskActionEvent.getElementName());
                panelTaskletRequest.setData("VOPFunction", (Object)functionDataBean.getFunctionNumber());
                panelTaskletRequest.setData("VOPFType", (Object)functionDataBean.getFunctionType());
                panelTaskletRequest.setData("LparNum", (Object)functionDataBean.getPartitionNumber());
            }
            catch (UnknownFunctionException unknownFunctionException) {
                Trace.trace((String)TRACE_MASKT, (Object)"<-- OPSFBean.panelAction() EARLY EXIT: unrecognized event");
                return;
            }
        }
        this.postTaskletRequest(panelTaskletRequest);
        this.userTaskManager.refreshAllElements();
        Trace.trace((String)TRACE_MASKT, (Object)"<-- OPSFBean.panelAction()");
    }

    private class UnknownFunctionException
    extends Exception {
        private UnknownFunctionException() {
        }
    }

    private class FunctionDataBean {
        private static final String FUNC20_NAME = "Function20";
        private static final String FUNC21_NAME = "Function21";
        private static final String FUNC65_NAME = "Function65";
        private static final String FUNC66_NAME = "Function66";
        private static final String FUNC67_NAME = "Function67";
        private static final String FUNC68_NAME = "Function68";
        private static final String FUNC69_NAME = "Function69";
        private static final String FUNC70_NAME = "Function70";
        private int functionNumber;
        private String functionType;
        private String partitionNumber;

        public FunctionDataBean(String string) throws UnknownFunctionException {
            Trace.trace((String)OperatorPanelServiceFunctionsBean.TRACE_MASKF, (Object)("<--> OPSFBean.FunctionDataBean(" + string + ")"));
            this.setData(string);
        }

        public Integer getFunctionNumber() {
            return new Integer(this.functionNumber);
        }

        public String getFunctionType() {
            return this.functionType;
        }

        public String getPartitionNumber() {
            return this.partitionNumber;
        }

        public void setData(String string) throws UnknownFunctionException {
            this.functionNumber = 0;
            if (string.endsWith(FUNC20_NAME)) {
                this.functionNumber = 20;
                this.functionType = "system";
                this.partitionNumber = null;
            } else if (string.endsWith(FUNC21_NAME)) {
                this.functionNumber = 21;
                this.functionType = "partition";
                this.partitionNumber = this.getSelectedPartitionNumber();
            } else if (string.endsWith(FUNC65_NAME)) {
                this.functionNumber = 65;
                this.functionType = "partition";
                this.partitionNumber = this.getSelectedPartitionNumber();
            } else if (string.endsWith(FUNC66_NAME)) {
                this.functionNumber = 66;
                this.functionType = "partition";
                this.partitionNumber = this.getSelectedPartitionNumber();
            } else if (string.endsWith(FUNC67_NAME)) {
                this.functionNumber = 67;
                this.functionType = "partition";
                this.partitionNumber = this.getSelectedPartitionNumber();
            } else if (string.endsWith(FUNC68_NAME)) {
                this.functionNumber = 68;
                this.functionType = "partition";
                this.partitionNumber = this.getSelectedPartitionNumber();
            } else if (string.endsWith(FUNC69_NAME)) {
                this.functionNumber = 69;
                this.functionType = "partition";
                this.partitionNumber = this.getSelectedPartitionNumber();
            } else if (string.endsWith(FUNC70_NAME)) {
                this.functionNumber = 70;
                this.functionType = "partition";
                this.partitionNumber = this.getSelectedPartitionNumber();
            } else {
                throw new UnknownFunctionException();
            }
        }

        private String getSelectedPartitionNumber() {
            if (OperatorPanelServiceFunctionsBean.this.partitionTableSelectedRows.length == 0) {
                return null;
            }
            return ((String[])OperatorPanelServiceFunctionsBean.this.partitionTable.get(OperatorPanelServiceFunctionsBean.this.partitionTableSelectedRows[0]))[1];
        }
    }
}

